<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Events\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class SubscriptionOptions {
    /**
     * @param string $sinkSid Sink SID.
     * @return ReadSubscriptionOptions Options builder
     */
    public static function read(string $sinkSid = Values::NONE): ReadSubscriptionOptions {
        return new ReadSubscriptionOptions($sinkSid);
    }

    /**
     * @param string $description Subscription description.
     * @param string $sinkSid Sink SID.
     * @return UpdateSubscriptionOptions Options builder
     */
    public static function update(string $description = Values::NONE, string $sinkSid = Values::NONE): UpdateSubscriptionOptions {
        return new UpdateSubscriptionOptions($description, $sinkSid);
    }
}

class ReadSubscriptionOptions extends Options {
    /**
     * @param string $sinkSid Sink SID.
     */
    public function __construct(string $sinkSid = Values::NONE) {
        $this->options['sinkSid'] = $sinkSid;
    }

    /**
     * The SID of the sink that the list of Subscriptions should be filtered by.
     *
     * @param string $sinkSid Sink SID.
     * @return $this Fluent Builder
     */
    public function setSinkSid(string $sinkSid): self {
        $this->options['sinkSid'] = $sinkSid;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Events.V1.ReadSubscriptionOptions ' . $options . ']';
    }
}

class UpdateSubscriptionOptions extends Options {
    /**
     * @param string $description Subscription description.
     * @param string $sinkSid Sink SID.
     */
    public function __construct(string $description = Values::NONE, string $sinkSid = Values::NONE) {
        $this->options['description'] = $description;
        $this->options['sinkSid'] = $sinkSid;
    }

    /**
     * A human readable description for the Subscription.
     *
     * @param string $description Subscription description.
     * @return $this Fluent Builder
     */
    public function setDescription(string $description): self {
        $this->options['description'] = $description;
        return $this;
    }

    /**
     * The SID of the sink that events selected by this subscription should be sent to. Sink must be active for the subscription to be created.
     *
     * @param string $sinkSid Sink SID.
     * @return $this Fluent Builder
     */
    public function setSinkSid(string $sinkSid): self {
        $this->options['sinkSid'] = $sinkSid;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Events.V1.UpdateSubscriptionOptions ' . $options . ']';
    }
}